#include <stdio.h>
#include "AD18F08.h"
#include "periph.h"

void GPIO_Init(void)
{
	TRISA = 0X00;   //PA口配置输出
	TRISB = 0X00;   //PB口配置输出
	
	PORTA = 0X00;	  //PORTA输出低
	PORTB = 0X00;	  //PORTB输出低
	
	PAPD = 0XFF;    //关闭PA下拉
	PAPU = 0XFF;    //关闭PA上拉
	PBPD = 0XFF;    //关闭PB下拉
	PBPU = 0XFF;    //关闭PB上拉
	
	PAOD = 0X00;    //关闭PA开漏
	PBOD = 0X00;    //关闭PB开漏
	
	ANASEL0 = 0X00; //关闭PA模拟通道
	ANASEL1 = 0X00; //关闭PB模拟通道
}



unsigned short ADC_SampleFilter(void)
{
    unsigned short Volt       = 0;

    while(GO);                       //A/D转换正在进行
    Volt = (ADRESH<<8)|ADRESL;//读取ADC采集值

    return Volt;
}
/*

*/
void ADC_Config(void)
{
	TRISA5 = 1;PA5PD = 1;PA5PU = 1;PA5OD = 0;PA5AEN = 1;//PA5设置为输入模式，上下拉关闭，开漏关闭，模拟通道开启
	ADCON0 = 0X49;  //配置PA5为ADC采集通道，使能A/D模拟使能位,ADCMPMODE =1,采集值小于ADCMP1H且大于ADCMP0H，产生中断ADCMP0IF；
	ADCON1 = 0XBE;  //参考电压选择VDD，A/D转换时钟选择FOSC/64(ADSP=1)

    ADCMP1H = 0x40;
    ADCMP01L= 0x08;
    ADCMP0H = 0x30;

    GIEH   = 1;
    GIEL   = 1;
    IPEN   = 1;
    ADCMP0IP = 1;
    ADCMP0IE = 1;
    ADCMP0IF = 0;

}

void timer1_int(void)
{
	TMR1H  = 0xFC;
       TMR1L  = 0X18;
       T1CON0 = 0x21;//系统时钟做计数时钟，4分频
       T1CON1 = 0x03;//定时器的工作模式2，定时触发启动ADC
       GIEH   = 1;
       GIEL   = 1;
       IPEN   = 1;
       TMR1IF = 0;
       TMR1IP = 1;
       TMR1IE = 0;
}
